package gov.va.vinci.dart.rule;

import java.util.Map;

import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;

public class TestOEFOIFScrambledDocumentRuleEvaluator extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");

		try {
			DartObjectFactory.getInstance().getUserManager().login(token);
			SecurityContextHolder.getContext().setAuthentication(token);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testOne() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		OEFOIFScrambledDocumentRuleEvaluator testable = new OEFOIFScrambledDocumentRuleEvaluator();
		
		// non-primary site
		Location site = Location.findById(2);
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();
		
		// loop on all data sources in a request, all sites in a request, and *all* document templates
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));
		
		// if a HIPAA waiver is required?
		((DartRequest)req).setHipaaWaiver(true);
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(13), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));
		
		// and the primary site?
		((DartRequest)req).setHipaaWaiver(false);
		
		// the primary site
		site = Location.findById(1);
		
		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), site, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), site, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(12), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));

		// if HIPAA consent required?
		((DartRequest)req).setHipaaConsent(true);
		
		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), site, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(7), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(12), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));
		
		// if HIPAA consent and HIPAA waiver required?
		((DartRequest)req).setHipaaConsent(true);
		((DartRequest)req).setHipaaWaiver(true);
		
		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), site, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(7), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), site, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(12), site, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(13), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), site, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), site, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), site, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), site, false));

	}

	@Test
	public void testTwo() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		OEFOIFScrambledDocumentRuleEvaluator testable = new OEFOIFScrambledDocumentRuleEvaluator();
		
		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);
		
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();

		// loop on all data sources in a request, all sites in a request, and *all* document templates

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, primarySite, false));
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), privacyGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), privacyGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), privacyGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), privacyGroup, primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), privacyGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), privacyGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), privacyGroup, primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(24), privacyGroup, primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), privacyGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), privacyGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), privacyGroup, primarySite, false));
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), ndsGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), ndsGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), ndsGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), ndsGroup, primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), ndsGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), ndsGroup, primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(21), ndsGroup, primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), ndsGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), ndsGroup, primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), ndsGroup, primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), ndsGroup, primarySite, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, site, false));

	}

	@Test
	public void testThree() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		Person pers5 = Person.findById(1014);  // non-primary site with data access

		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);
		Participant participant5 = Participant.create(pers5, req, site, true, true, false);

		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		OEFOIFScrambledDocumentRuleEvaluator testable = new OEFOIFScrambledDocumentRuleEvaluator();
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();

		// loop on all data sources in a request, all sites in a request, and *all* document templates

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant1, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(10), participant1, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant1, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant1, false));

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant2, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), participant2, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant2, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant2, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant2, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant2, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant2, false));

		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant3, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(10), participant3, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant3, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant3, false));
		
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant4, false));
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant5, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant5, false));
		//Assert.assertTrue(testable.isRequired(req, ds, map.get(10), participant5, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant5, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant5, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant5, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant5, false));

	}

	@Test
	public void testFour() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		Person pers5 = Person.findById(1014);  // non-primary site with data access
		
		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);
		Participant participant5 = Participant.create(pers5, req, site, true, true, false);

		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		OEFOIFScrambledDocumentRuleEvaluator testable = new OEFOIFScrambledDocumentRuleEvaluator();
		
		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();

		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);

		
		// loop on all data sources in a request, all sites in a request, and *all* document templates

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant5, false));
		
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant5, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant5, false));
	}
}
